/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;

public class MagicProtectionEnchantment
extends CustomEnchantment {
    public MagicProtectionEnchantment() {
        this.rarity(Enchantment.Rarity.UNCOMMON).category(EnchantmentCategory.ARMOR).slots(EquipmentSlots.ARMOR).maxLevel(4).minLevelCost(level -> level * 11 - 10).maxLevelCost(level -> level * 11 + 1);
    }

    public int m_7205_(int level, DamageSource source) {
        return !source.m_19390_() && source.m_19387_() ? level * 2 : 0;
    }

    protected boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof ProtectionEnchantment) && super.m_5975_(enchantment);
    }

    @AutoInstance
    public static class Handler {
        final Supplier<MagicProtectionEnchantment> enchantment = Registries.MAGIC_PROTECTION;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("MagicProtection").comment("Protects against magical damage like Evoker Fangs, Guardians and Instant Damage potions.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
        }
    }
}

